% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unSurv.R
\name{unSurv}
\alias{unSurv}
\title{Converts Surv object into a 3-column matrix}
\usage{
unSurv(x, col_lo = "lo", col_hi = "hi")
}
\arguments{
\item{x}{vector (Surv object)}

\item{col_lo}{Output column name for "lo" values.  Default = "lo"}

\item{col_hi}{Output column name for "hi" values.  Default = "hi"}
}
\value{
Returns a 3-column matrix: lo, hi, type
}
\description{
Converts Surv object into a 3-column matrix
}
\details{
The third column of the returned matrix (type) has the following 
meanings:

 1  -- no censoring
 
 2  -- left censored ("less than in a survival sense"
 , e.g., [-Inf to 10], <10)
 
 3  -- interval censored ("less than in a water quality sense", 
 e.g., "0 - <3", "1 - 3")
 
 NA -- missing value
 
The user can specify the names of the low and high columns in the output.
Defaults are "lo" and "hi".
}
\examples{
df1 <- dataCensored[dataCensored$station=="CB3.3C"
          & dataCensored$date < as.POSIXct("1985-08-01") 
          , c("station","date","chla")]
colnames(df1)
# Default values
chla_1 <- unSurv(df1$chla)
colnames(chla_1)
# User values
chla_2 <- unSurv(df1$chla, "LOW", "HIGH")
colnames(chla_2)

}
\seealso{
\code{\link{makeSurvDF}},  \code{\link{unSurvDF}}
,  \code{\link{impute}},  \code{\link{imputeDF}},  \code{\link{saveDF}},
}
