% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdata_nobs.R
\name{nobs}
\alias{nobs}
\title{Compute the Number of Non-Missing Observations}
\usage{
nobs(object, ...)
}
\arguments{
\item{object}{Target Object}

\item{...}{Optional parameters (currently ignored)}
}
\description{
Compute the number of non-missing observations. 
Provides a 'default' method to handle vectors, and a method for data frames.
}
\details{
Calculate the number of observations in `object`.

* For numeric vectors, this is simply the number of non-NA elements, as computed by `sum(!is.na(object))`.

* For dataframe objects, the result is a vector containing the number of non-NA elementes of each column.

The `nobs` and `nobs.lm` functions defined in gtools are simply aliases for the 
functions in the base R `stats` package, provided for backwards compatibility.

`baytrends` borrowed `gdata::nobs` 'as is' to avoid being archived in 2020.
https://github.com/tetratech/baytrends/issues/56
}
\note{
The base R package `stats` now provides a S3 dispatch function for nobs, and methods 
for for objects of classes "lm", "glm", "nls" and "logLik", as well as a default method.

Since they provided a subset of the the functionality, the base method dispatch 
(nobs) function and method for "lm" objects (`nobs.lm`) are, as of gdata version 2.10.1, 
simply aliases for the equivalent functions in the base R `stats` package.

Since `gdata`'s default method (`nobs.default`) processes vectors and hands any other 
data/object types to `stats:::nobs.default`.
}
\examples{
x <- c(1,2,3,5,NA,6,7,1,NA )
length(x)
nobs(x)

df <- data.frame(x=rnorm(100), y=rnorm(100))
df[1,1] <- NA
df[1,2] <- NA
df[2,1] <- NA

nobs(df)

fit <- lm(y ~ x, data=df)
nobs(fit)

}
\author{
Gregory R. Warnes greg@warnes.net
}
