% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{bb_data}
\alias{bb_data}
\title{Returns data for a given flow and key}
\usage{
bb_data(
  flow,
  key,
  start_period = NULL,
  end_period = NULL,
  first_n = NULL,
  last_n = NULL
)
}
\arguments{
\item{flow}{\code{character(1)} flow to query, 5-8 characters.
See \code{\link[=bb_metadata]{bb_metadata()}} for available dataflows.}

\item{key}{\code{character(1)} key to query.}

\item{start_period}{\code{character(1)} start date of the data. Supported formats:
\itemize{
\item YYYY for annual data (e.g., "2019")
\item YYYY-S[1-2] for semi-annual data (e.g., "2019-S1")
\item YYYY-Q[1-4] for quarterly data (e.g., "2019-Q1")
\item YYYY-MM for monthly data (e.g., "2019-01")
\item YYYY-W[01-53] for weekly data (e.g., "2019-W01")
\item YYYY-MM-DD for daily and business data (e.g., "2019-01-01")
If \code{NULL}, no start date restriction is applied (data retrieved from the
earliest available date). Default \code{NULL}.
}}

\item{end_period}{\code{character(1)} end date of the data, in the same format as
start_period. If \code{NULL}, no end date restriction is applied (data
retrieved up to the most recent available date). Default \code{NULL}.}

\item{first_n}{\code{numeric(1)} number of observations to retrieve from the
start of the series. If \code{NULL}, no restriction is applied. Default \code{NULL}.}

\item{last_n}{\code{numeric(1)} number of observations to retrieve from the end
of the series. If \code{NULL}, no restriction is applied. Default \code{NULL}.}
}
\value{
A \code{data.frame()} with the requested data. The columns are:
\item{date}{The date of the observation}
\item{key}{The time series key}
\item{title}{The title of the dataflow}
\item{category}{The category of the observation}
\item{unit}{The unit of the observation}
\item{unit_multiplier}{The unit multiplier of the observation}
\item{frequency}{The frequency of the observation}
\item{value}{The value of the observation}
}
\description{
Returns data for a given flow and key
}
\examples{
\donttest{
# fetch all data for a given flow and key
bb_data("BBSIS", "D.I.ZAR.ZI.EUR.S1311.B.A604.R10XX.R.A.A._Z._Z.A")

# specified period (start date-end date) for daily data
bb_data(
  "BBSIS", "D.I.ZAR.ZI.EUR.S1311.B.A604.R10XX.R.A.A._Z._Z.A",
  start_period = "2020-01-01",
  end_period = "2020-08-01"
)
# or only specify the start date
bb_data(
  "BBSIS", "D.I.ZAR.ZI.EUR.S1311.B.A604.R10XX.R.A.A._Z._Z.A",
  start_period = "2020-01-01"
)
}
}
\references{
\url{https://www.bundesbank.de/en/statistics/time-series-databases/help-for-sdmx-web-service/web-service-interface-data}
}
\seealso{
Other data: 
\code{\link{bb_series}()}
}
\concept{data}
