% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onb.R
\name{onb_data}
\alias{onb_data}
\title{Fetch Österreichische Nationalbank (OeNB) data}
\source{
\url{https://www.oenb.at/en/Statistics/User-Defined-Tables/webservice.html}
}
\usage{
onb_data(
  hier_id,
  key,
  ...,
  start_period = NULL,
  end_period = NULL,
  freq = NULL,
  lang = "en"
)
}
\arguments{
\item{hier_id}{(\code{integer(1)})\cr
Hierarchy id to query.}

\item{key}{(\code{character()})\cr
The series keys to query.}

\item{...}{(\code{any})\cr
Additional parameters to pass to the API.}

\item{start_period}{(\code{NULL} | \code{character(1)} | \code{integer(1)})\cr
Start date of the data.}

\item{end_period}{(\code{NULL} | \code{character(1)} | \code{integer(1)})\cr
End date of the data.}

\item{freq}{(\code{NULL} | \code{character(1)})\cr
Frequency of the data.}

\item{lang}{(\code{character(1)})\cr
Language to query. Default \code{"en"}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Retrieve time series data from the OeNB Web Service.
}
\examples{
\donttest{
onb_data(hier_id = 11, key = "VDBFKBSC217000")
# Loans to euro area residents, since 2000:
onb_data(hier_id = 11, key = "VDBFKBSC217000", start_period = "2000-01-01")
# Austrian imports and exports of goods from/to Germany, 2002–2012, annual frequency:
onb_data(hier_id = 901, key = "VDBQZA1000", start_period = 2002, end_period = 2012, freq = "A")
# Number of Austrian banks' subsidiaries abroad an in the EU, from 2005, semiannual:
onb_data(
  hier_id = 321,
  key = c("VDBKISDANZTAU", "VDBKISDANZTEU"),
  start_period = 200501,
  freq = "H"
)
}
}
\seealso{
Other data: 
\code{\link{bbk_data}()},
\code{\link{bbk_series}()},
\code{\link{bde_data}()},
\code{\link{bdf_codelist}()},
\code{\link{bdf_data}()},
\code{\link{bdf_dataset}()},
\code{\link{boe_data}()},
\code{\link{ecb_data}()},
\code{\link{snb_data}()}
}
\concept{data}
