% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_val.R
\name{crossVal}
\alias{crossVal}
\title{Cross-Validation of BB Learning}
\usage{
crossVal(formula, data, freq = NULL, novarOk = FALSE, lambda = 1e-05,
  lambdah = 0, eps = 0.9, nfold = 5, method = "pseudo",
  naive = FALSE, use.auc = TRUE, verbose = 1, progress.bar = FALSE,
  storeOpt = TRUE, ...)
}
\arguments{
\item{formula}{Formula for model. Note that intercept has no effect.}

\item{data}{Data frame of data. Column names must match \code{formula}.}

\item{freq}{Frequency vector of how many times each row of \code{data} must
be repeated. If \code{NULL}, defaults to vector of 1s.
Fractional values are not supported.}

\item{novarOk}{Proceed even when there are predictors with only one factor level.}

\item{lambda}{Vector of L2 penalizer values for \code{method = 'pseudo'}. Inferences
will be repeated for each value. Restricited to non-negative values.}

\item{lambdah}{L2 penalizer in \code{method = 'pseudo'} applied to
parameter \code{h}. In contrast to \code{lambda},
only a single value is allowed.}

\item{eps}{Vector of regularization parameters, \eqn{\epsilon\in[0,1]},
for \code{method = 'mf'}. Inference will be repeated
for each value.}

\item{nfold}{Number of folds for training/validation split.}

\item{method}{\code{c('pseudo','mf')} for pseudo-likelihood maximization or
mean field.}

\item{naive}{Naive Bayes (no interactions). Equivalent to \code{method = 'mf'}
together with \code{eps = 0}.}

\item{use.auc}{Use AUC as the measure of prediction accuracy. Only works
if response groups are binary. If \code{FALSE}, mean prediction group
accuracy will be used as score.}

\item{verbose}{Verbosity level. Downgraded when relayed into \code{\link{bbl}}.}

\item{progress.bar}{Display progress bar in \code{\link{predict}}.}

\item{storeOpt}{Store the optimal fitted object of class \code{\link{bbl}}.}

\item{...}{Other parameters to \code{\link{mlestimate}}.}
}
\value{
Object of class \code{cv.bbl} extending \code{\link{bbl}}, a list
with extra components
\item{regstar}{Value of regularization parameter, \code{lambda}
and \code{eps} for \code{method='pseudo'} and \code{method='mf'},
respectively, at which the accuracy score is maximized}
\item{maxscore}{Value of maximum accuracy score}
\item{cvframe}{Data frame of regularization parameters and scores scanned}
The components of \code{\link{bbl}} store the optimal model trained
if \code{storeOpt=TRUE}.
}
\description{
Run multiple fittings of \code{bbl} model with training/validation
division of data
}
\details{
The \code{data} slot of \code{object} is split into training and validation
subsets of (\code{nfold}-1):1 ratio. The model is trained with the
former and validated on the latter. Individual division/fold results are
combined into validation result for all instances in the data set and
prediction score is evaluated using the known response group
identity.
}
\examples{
set.seed(513)
m <- 5
n <- 100
predictors <- list()
for(i in 1:m) predictors[[i]] <- c('a','c','g','t')
names(predictors) <- paste0('v',1:m)
par <- list(randompar(predictors), randompar(predictors, h0=0.1, J0=0.1))
dat <- randomsamp(predictors, response=c('ctrl','case'), par=par, nsample=n)
cv <- crossVal(y ~ .^2, data=dat, method='mf', eps=seq(0.1,0.9,0.1))
cv
}
