% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Terminator.R
\name{Terminator}
\alias{Terminator}
\title{Abstract Terminator Class}
\description{
Abstract \code{Terminator} class that implements the base functionality each
terminator must provide. A terminator is an object that determines when to
stop the optimization.

Termination of optimization works as follows:
\itemize{
\item Evaluations in a instance are performed in batches.
\item Before each batch evaluation, the \link{Terminator} is checked, and if it is positive,
we stop.
\item The optimization algorithm itself might decide not to produce any more points,
or even might decide to do a smaller batch in its last evaluation.
}

Therefore the following note seems in order: While it is definitely possible
to execute a fine-grained control for termination, and for many optimization
algorithms we can specify exactly when to stop, it might happen that too few
or even too many evaluations are performed, especially if multiple points are
evaluated in a single batch (c.f. batch size parameter of many optimization
algorithms). So it is advised to check the size of the returned archive, in
particular if you are benchmarking multiple optimization algorithms.
}
\seealso{
Other Terminator: 
\code{\link{mlr_terminators_clock_time}},
\code{\link{mlr_terminators_combo}},
\code{\link{mlr_terminators_evals}},
\code{\link{mlr_terminators_none}},
\code{\link{mlr_terminators_perf_reached}},
\code{\link{mlr_terminators_run_time}},
\code{\link{mlr_terminators_stagnation_batch}},
\code{\link{mlr_terminators_stagnation}},
\code{\link{mlr_terminators}}
}
\concept{Terminator}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{param_set}}{\link[paradox:ParamSet]{paradox::ParamSet}\cr
Set of control parameters for terminator.}

\item{\code{properties}}{\code{character()}\cr
Set of properties.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Terminator$new()}}
\item \href{#method-format}{\code{Terminator$format()}}
\item \href{#method-print}{\code{Terminator$print()}}
\item \href{#method-clone}{\code{Terminator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Terminator$new(param_set = ParamSet$new(), properties = character())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of control parameters for terminator.}

\item{\code{properties}}{(\code{character()})\cr
Set of properties.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Terminator$format()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Printer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Terminator$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Terminator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
