% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{GaussianInvWishart}
\alias{GaussianInvWishart}
\title{Create objects of type "GaussianInvWishart".}
\usage{
GaussianInvWishart(
  objCopy = NULL,
  ENV = parent.frame(),
  gamma = list(mu = 0, v = 3, S = 1)
)
}
\arguments{
\item{objCopy}{an object of type "GaussianInvWishart". If "objCopy" is not NULL, the function create a new "GaussianInvWishart" object by copying the content from objCopy, otherwise this new object will be created by using "ENV" and "gamma". Default NULL.}

\item{ENV}{environment, specify where the object will be created.}

\item{gamma}{list, a named list of parameters, gamma=list(mu,v,S). Where gamma$mu is the known mean vector of x, gamma$v and gamma$S are the prior degree of freedom and scale of Sigma.}
}
\value{
An object of class "GaussianInvWishart".
}
\description{
Create an object of type "GaussianInvWishart", which represents the Gaussian and Inverse-Wishart conjugate structure:
    \deqn{x ~ Gaussian(mu,Sigma)}
    \deqn{Sigma ~ InvWishart(v,S)}
mu is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} and \code{?dInvWishart} for the definition of the distributions.\cr
The created object will be used as a place for recording and accumulating information in the related inference/sampling functions such as posterior(), posteriorDiscard(), MAP(), marginalLikelihood(), dPosteriorPredictive(), rPosteriorPredictive() and so on.
}
\examples{
obj <- GaussianInvWishart(gamma=list(mu=c(-1.5,1.5),v=3,S=diag(2)))
obj #print the content
}
\references{
Gelman, Andrew, et al. Bayesian data analysis. CRC press, 2013.
}
\seealso{
\code{\link{posterior.GaussianInvWishart}},\code{\link{posteriorDiscard.GaussianInvWishart}},\code{\link{MAP.GaussianInvWishart}},\code{\link{MPE.GaussianInvWishart}},\code{\link{marginalLikelihood.GaussianInvWishart}},\code{\link{rPosteriorPredictive.GaussianInvWishart}},\code{\link{dPosteriorPredictive.GaussianInvWishart}} ...
}
