% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{dPosteriorPredictive.CatDP}
\alias{dPosteriorPredictive.CatDP}
\title{Posterior predictive density function of a "CatDP" object}
\usage{
\method{dPosteriorPredictive}{CatDP}(obj, x, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "CatDP" object.}

\item{x}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure:
     \deqn{pi|alpha ~ DP(alpha,U)}
     \deqn{x|pi ~ Categorical(pi)}
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process, it is an uniform distribution on all positive integers.Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatDP, x can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatDP" object. \cr
Posterior predictive density is p(x|alpha).
}
\examples{
x <- sample(1L:10L,size = 40,replace = TRUE)
obj <- CatDP()
ss <- sufficientStatistics(obj=obj,x=x)
posterior(obj = obj,ss = ss)
dPosteriorPredictive(obj = obj,x=1L:11L,LOG = FALSE)
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatDP}}, \code{\link{dPosteriorPredictive.CatDP}}, \code{\link{marginalLikelihood.CatDP}}
}
