% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayesian_Bricks.r
\name{posteriorDiscard}
\alias{posteriorDiscard}
\title{update the prior distribution with sufficient statistics}
\usage{
posteriorDiscard(obj, ...)
}
\arguments{
\item{obj}{A "BayesianBrick" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
None, or an error message if the update fails.
}
\description{
Contrary to posterior(), posteriorDiscard() a generic function that will update the prior distribution of a "BayesianBrick" object by removing the information provided by the observation's sufficient statistics. i.e. for the model structure:
     \deqn{theta|gamma \sim H(gamma)}
     \deqn{x|theta \sim F(theta)}
update gamma to gamma_posterior by removing the information of x from gamma.
For a given sample set x or it's sufficient statistics ss, and a Bayesian bricks object obj, \code{posteriorDiscard()} will update the posterior parameters in obj for different model structures:
\subsection{class(obj)="LinearGaussianGaussian"}{
     \deqn{x \sim Gaussian(A z + b, Sigma)}
     \deqn{z \sim Gaussian(m,S)}
\code{posteriorDiscard()} will update m and S in obj.
See \code{?posteriorDiscard.LinearGaussianGaussian} for details.
}
\subsection{class(obj)="GaussianGaussian"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{mu \sim Gaussian(m,S)}
Sigma is known.
\code{posteriorDiscard()} will update m and S in obj.
See \code{?posteriorDiscard.GaussianGaussian} for details.
}
\subsection{class(obj)="GaussianInvWishart"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{Sigma \sim InvWishart(v,S)}
mu is known.
\code{posteriorDiscard()} will update v and S in obj.
See \code{?posteriorDiscard.GaussianInvWishart} for details.
}
\subsection{class(obj)="GaussianNIW"}{
Where
\deqn{x \sim Gaussian(mu,Sigma)}
\deqn{Sigma \sim InvWishart(v,S)}
\deqn{mu \sim Gaussian(m,Sigma/k)}
\code{posteriorDiscard()} will update m, k, v and S in obj.
See \code{?posteriorDiscard.GaussianNIW} for details.
}
\subsection{class(obj)="GaussianNIG"}{
Where
\deqn{x \sim Gaussian(X beta,sigma^2)}
\deqn{sigma^2 \sim InvGamma(a,b)}
\deqn{beta \sim Gaussian(m,sigma^2 V)}
\code{posteriorDiscard()} will update m, V, a and b in obj.
See \code{?posteriorDiscard.GaussianNIG} for details.
}
\subsection{class(obj)="CatDirichlet"}{
Where
\deqn{x \sim Categorical(pi)}
\deqn{pi \sim Dirichlet(alpha)}
\code{posteriorDiscard()} will update alpha in obj.
See \code{?posteriorDiscard.CatDirichlet} for details.
}
\subsection{class(obj)="CatDP"}{
Where
\deqn{x \sim Categorical(pi)}
\deqn{pi \sim DirichletProcess(alpha)}
\code{posteriorDiscard()} will update alpha in obj.
See \code{?posteriorDiscard.CatDP} for details.
}
\subsection{class(obj)="DP"}{
Where
     \deqn{pi|alpha \sim DP(alpha,U)}
    \deqn{z|pi \sim Categorical(pi)}
     \deqn{theta_z|psi \sim H0(psi)}
     \deqn{x|theta_z,z \sim F(theta_z)}
\code{posteriorDiscard()} will update alpha and psi in obj.
See \code{?posteriorDiscard.DP} for details.
}
\subsection{class(obj)="HDP"}{
Where
     \deqn{G_j|gamma \sim DP(gamma,U), j = 1:J}
     \deqn{pi_j|G_j,alpha \sim DP(alpha,G_j)}
     \deqn{z|pi_j \sim Categorical(pi_j)}
     \deqn{k|z,G_j \sim Categorical(G_j), if z is a sample from the base measure G}
     \deqn{theta_k|psi \sim H0(psi)}
\code{posteriorDiscard()} will update gamma, alpha and psi in obj.
See \code{?posteriorDiscard.HDP} for details.
}
\subsection{class(obj)="HDP2"}{
Where
     \deqn{G_m |eta \sim DP(eta,U), m = 1:M}
     \deqn{G_mj|gamma,G_m \sim DP(gamma,G_m), j = 1:J_m}
     \deqn{pi_mj|G_mj,alpha \sim DP(alpha,G_mj)}
     \deqn{z|pi_mj \sim Categorical(pi_mj)}
     \deqn{k|z,G_mj \sim Categorical(G_mj), if z is a sample from the base measure G_mj}
     \deqn{u|k,G_m \sim Categorical(G_m), if k is a sample from the base measure G_m}
     \deqn{theta_u|psi \sim H0(psi)}
     \deqn{x|theta_u,u \sim F(theta_u)}
\code{posteriorDiscard()} will update eta, gamma, alpha and psi in obj.
See \code{?posteriorDiscard.HDP2} for details.
}
}
\seealso{
\code{\link{posteriorDiscard.LinearGaussianGaussian}} for Linear Gaussian and Gaussian conjugate structure, \code{\link{posteriorDiscard.GaussianGaussian}} for Gaussian-Gaussian conjugate structure, \code{\link{posteriorDiscard.GaussianInvWishart}} for Gaussian-Inverse-Wishart conjugate structure, \code{\link{posteriorDiscard.GaussianNIW}} for Gaussian-NIW conjugate structure, \code{\link{posteriorDiscard.GaussianNIG}} for Gaussian-NIG conjugate structure, \code{\link{posteriorDiscard.CatDirichlet}} for Categorical-Dirichlet conjugate structure, \code{\link{posteriorDiscard.CatDP}} for Categorical-DP conjugate structure ...
}
