% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{dAllIndicators}
\alias{dAllIndicators}
\title{Get the probabilities of all possible values of the hidden indicator variables from the DP family objects.}
\usage{
dAllIndicators(obj, ...)
}
\arguments{
\item{obj}{A "CatDP", "CatHDP", "CatHDP2", "DP", "HDP", or a "HDP2" object used to select a method.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a data.frame of indicator values and their corresponding probabilities.
}
\description{
This is a generic function that will get the probabilities of all possible values of the hidden indicator variables. i.e. for the model structure: \cr
     \deqn{theta|gamma_1 \sim H1(gamma_1)}
     \deqn{z|gamma_2 \sim H2(gamma_2)}
     \deqn{x|theta,z \sim F(theta_z)}
get p(z|x,gamma_2,gamma_1) for all possible values of z. Where H2 is either CatDP, CatHDP, CatHDP2, DP, HDP, or HDP2.
}
