% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{marginalLikelihood.CatDP}
\alias{marginalLikelihood.CatDP}
\title{Marginal likelihood of a "CatDP" object}
\usage{
\method{marginalLikelihood}{CatDP}(obj, x, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "CatDP" object.}

\item{x}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the marginal likelihood.
}
\description{
Generate the marginal likelihood of the following model structure:
     \deqn{pi|alpha \sim DP(alpha,U)}
     \deqn{x|pi \sim Categorical(pi)}
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process, it is an uniform distribution on all positive integers.Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatDP, x can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatDP" object. \cr
Marginal likelihood = p(x|alpha).
}
\seealso{
\code{\link{CatDP}}, \code{\link{marginalLikelihood_bySufficientStatistics.CatDP}}
}
