% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-classes.R, R/utils-filter.R
\name{filter.bcdc_promise}
\alias{filter.bcdc_promise}
\alias{filter}
\title{Filter a query from Web Service call}
\usage{
\method{filter}{bcdc_promise}(.data, ...)
}
\arguments{
\item{.data}{object of class \code{bcdc_promise} (likely passed from \code{\link[=bcdc_query_geodata]{bcdc_query_geodata()}})}

\item{...}{Logical predicates with which to filter the results. Multiple
conditions are combined with \code{&}. Only rows where the condition evaluates to
\code{TRUE} are kept. Accepts normal R expressions as well as any of the special
\link[=cql_geom_predicates]{CQL geometry functions} such as \code{WITHIN()} or \code{INTERSECTS()}.
If you know \code{CQL} and want to write a \code{CQL} query directly, write it enclosed
in quotes, wrapped in the \code{\link[=CQL]{CQL()}} function. e.g., \code{CQL("ID = '42'")}}
}
\description{
Filter a query from Web Service using dplyr methods. This filtering is accomplished lazily so that the
full sf object is not read into memory until \code{collect()} has been called.

See \code{dplyr::\link[dplyr]{filter}} for details.
}
\section{Methods (by class)}{
\itemize{
\item \code{bcdc_promise}: filter.bcdc_promise
}}

\examples{
\donttest{
  crd <- bcdc_query_geodata("regional-districts-legally-defined-administrative-areas-of-bc") \%>\%
    filter(ADMIN_AREA_NAME == "Cariboo Regional District") \%>\%
    collect()

ret1 <- bcdc_query_geodata("fire-perimeters-historical") \%>\%
  filter(FIRE_YEAR == 2000, FIRE_CAUSE == "Person", INTERSECTS(crd)) \%>\%
  collect()
  }
}
\keyword{internal}
