% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persp_bcgam.R
\name{persp.bcgam}
\alias{persp.bcgam}
\title{3D plots for \pkg{bcgam} fits}
\usage{
\method{persp}{bcgam}(x, x1, x2, parameter = "mu", level = 0.95,
  x1.grid = 10, x2.grid = 10, lty = 1, lty.inter = 1,
  ticktype = "detailed", col = 4, col.inter = col, surf.inter = TRUE,
  zlim = NULL, ...)
}
\arguments{
\item{x}{Object of class inheriting from "bcgam".}

\item{x1}{A non-parametrically modelled predictor in a bcgam fit. The predictor in the \eqn{x} axis. There is no default variable.}

\item{x2}{A non-parametrically modelled predictor in a bcgam fit. The predictor in the \eqn{y} axis. There is no default variable.}

\item{parameter}{The type of parameter to be plotted. If parameter=\code{"eta"}, then the systematic component
\eqn{\eta} is plotted. If parameter=\code{"mu"}, then the mean value \eqn{\mu} obtained by transforming
\eqn{\eta} using the inverse of the link function is plotted. The default is \code{"mu"}.}

\item{level}{Tolerance/credible level. The default is \code{0.95}.}

\item{x1.grid}{A positive integer that specifies how dense the \eqn{x} grid will be. The default is \code{10}.}

\item{x2.grid}{A positive integer that specifies how dense the \eqn{y} grid will be. The default is \code{10}.}

\item{lty}{What type of surface edges should be drawn for fitted values. The default is a solid line (\code{1}).}

\item{lty.inter}{What type of surface edges should be drawn for interval estimates. The default is a solid line (\code{1}).}

\item{ticktype}{character: "detailed" draws normal ticks; "simple" draws just an arrow parallel to the
axis to indicate direction of increase. The default is \code{"detailed"}.}

\item{col}{Color of fitted surface. The default is blue (\code{4}).}

\item{col.inter}{Color of interval estimates. If not specified, it takes the
same value as \code{col}.}

\item{surf.inter}{Indicator to draw interval estimates (\code{"TRUE"}) or not (\code{"FALSE"}). 
The default is \code{"TRUE"}.}

\item{zlim}{The \code{z} limits of the plot. If \code{zlim=NULL} and \code{surf.inter="TRUE"}, 
then the minimum value of the lower bound estimates and the maximum value of the upper bound estimates are used.
If \code{zlim=NULL} and \code{surf.inter="FALSE"}, then the minimum and maximum values of the fitted surface are used.
The default is \code{NULL}.}

\item{...}{additional graphical parameters.}
}
\description{
3D plots of fitted surface with credible interval estimates based on a \code{bcgam} object and two non-parametrically
modelled predictors.
}
\details{
\code{persp.bcgam} produces 3D plots based on the \code{bcgam} object. Interval
estimates are based on the specified \code{level}. 

If there are more than two non-parametrically modelled predictors,
then these will be evaluated at the largest values that are smaller than or equal 
to their median values. Categorical covariates will be evaluated at their mode. Also,
continuous covariates will be evaluated at the largest values that are smaller than
or equal to their median values.

This routine creates 3D plots based on the posterior distribution in the \code{bcgam} object.
}
\examples{
\dontrun{
n<-50
x1<-(1:n/n)^{1/3}
x2<-log(1:n/n)
z<-as.factor(rbinom(n, 1, 0.6))
eta<-x1+x2+0.2*as.numeric(z)+rnorm(n, sd=0.2)
mu<-exp(eta)/(1+exp(eta))
y<-(mu<0.6)

bcgam.fit <- bcgam(y~sm.incr(x1)+sm.conc(x2, numknots=8)+z, nloop=10000, family="binomial")
persp(bcgam.fit, x1, x2, parameter="eta", col.inter=2, level=0.90, theta=-55)
}
}
\author{
Cristian Oliva-Aviles and Mary C. Meyer
}
\keyword{internal}
