# Copyright 2015 Province of British Columbia
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and limitations under the License.

#' bcmaps: A data package providing various map layers for British Columbia
#'
#' Various layers of B.C., including administrative boundaries, natural
#' resource management boundaries, etc. All layers are available as both [sf](https://CRAN.R-project.org/package=sf )
#' and [Spatial](https://CRAN.R-project.org/package=sp)  objects, and are in
#' [BC Albers](https://spatialreference.org/ref/epsg/nad83-bc-albers/)
#' equal-area projection, which is the B.C. government standard.
#' The layers are sourced from the British Columbia and Canadian government under open licenses, including
#' [DataBC](https://data.gov.bc.ca), the Government of Canada
#' [Open Data Portal](https://open.canada.ca/en/open-data), and
#' [Statistics Canada](https://www.statcan.gc.ca/eng/reference/licence).
#' Each layer's individual help page contains a section describing the source for the data.
#'
#' @import sf
#' @importFrom utils download.file unzip
#'
#' @docType package
#' @name bcmaps
NULL
