% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortcuts.R
\name{nr_regions}
\alias{nr_regions}
\title{British Columbia Natural Resource (NR) Regions}
\source{
\code{bcdata::bcdc_get_data(record = 'dfc492c0-69c5-4c20-a6de-2c9bc999301f', resource = 'ec636f64-9c5f-4704-8e66-2dd43032c9b5')}
}
\usage{
nr_regions(ask = interactive(), force = FALSE)
}
\arguments{
\item{ask}{Should the function ask the user before downloading the data to a cache? Defaults to the value of interactive().}

\item{force}{Should you force download the data?}
}
\value{
The spatial layer of \code{nr_regions} as an \code{sf} object.
}
\description{
British Columbia Natural Resource (NR) Regions
}
\examples{
\dontrun{
my_layer <- nr_regions()
}

}
\seealso{
Other BC layers: 
\code{\link{airzones}()},
\code{\link{bc_bound_hres}()},
\code{\link{bc_bound}()},
\code{\link{bc_cities}()},
\code{\link{bec}()},
\code{\link{census_dissemination_area}()},
\code{\link{census_division}()},
\code{\link{census_economic}()},
\code{\link{census_metropolitan_area}()},
\code{\link{census_subdivision}()},
\code{\link{census_tract}()},
\code{\link{ecoprovinces}()},
\code{\link{ecoregions}()},
\code{\link{ecosections}()},
\code{\link{fsa}()},
\code{\link{gw_aquifers}()},
\code{\link{health_chsa}()},
\code{\link{health_ha}()},
\code{\link{health_hsda}()},
\code{\link{health_lha}()},
\code{\link{hydrozones}()},
\code{\link{mapsheets_250K}()},
\code{\link{mapsheets_50K}()},
\code{\link{municipalities}()},
\code{\link{nr_areas}()},
\code{\link{nr_districts}()},
\code{\link{regional_districts}()},
\code{\link{tsa}()},
\code{\link{water_districts}()},
\code{\link{water_precincts}()},
\code{\link{watercourses_15M}()},
\code{\link{watercourses_5M}()},
\code{\link{wsc_drainages}()}
}
\concept{BC layers}
