% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterjectionPipe.R
\name{InterjectionPipe}
\alias{InterjectionPipe}
\title{Class to find and/or remove the interjections on the data field of an Instance}
\description{
\code{\link{InterjectionPipe}} class is responsible for detecting
the existing interjections in the \strong{data} field of each \code{\link{Instance}}.
Identified interjections are stored inside the \strong{interjection} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
interjections removement.
}
\section{Details}{

\code{\link{InterjectionPipe}} class requires the resource files (in json format)
containing the list of interjections. To this end, the language of the text
indicated in the \emph{propertyLanguageName} should be contained in the
resource file name (ie. interj.xxx.json where xxx is the value defined in the
\emph{propertyLanguageName} ). The location of the resources should be
defined in the \strong{"resources.interjections.path"} field of
\emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{InterjectionPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{InterjectionPipe}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{InterjectionPipe$new()}}
\item \href{#method-pipe}{\code{InterjectionPipe$pipe()}}
\item \href{#method-findInterjection}{\code{InterjectionPipe$findInterjection()}}
\item \href{#method-removeInterjection}{\code{InterjectionPipe$removeInterjection()}}
\item \href{#method-getPropertyLanguageName}{\code{InterjectionPipe$getPropertyLanguageName()}}
\item \href{#method-getResourcesInterjectionsPath}{\code{InterjectionPipe$getResourcesInterjectionsPath()}}
\item \href{#method-setResourcesInterjectionsPath}{\code{InterjectionPipe$setResourcesInterjectionsPath()}}
\item \href{#method-clone}{\code{InterjectionPipe$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps">}\href{../../bdpar/html/GenericPipe.html#method-getAlwaysBeforeDeps}{\code{bdpar::GenericPipe$getAlwaysBeforeDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps">}\href{../../bdpar/html/GenericPipe.html#method-getNotAfterDeps}{\code{bdpar::GenericPipe$getNotAfterDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName">}\href{../../bdpar/html/GenericPipe.html#method-getPropertyName}{\code{bdpar::GenericPipe$getPropertyName()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash">}\href{../../bdpar/html/GenericPipe.html#method-hash}{\code{bdpar::GenericPipe$hash()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps">}\href{../../bdpar/html/GenericPipe.html#method-setAlwaysBeforeDeps}{\code{bdpar::GenericPipe$setAlwaysBeforeDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps">}\href{../../bdpar/html/GenericPipe.html#method-setNotAfterDeps}{\code{bdpar::GenericPipe$setNotAfterDeps()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName">}\href{../../bdpar/html/GenericPipe.html#method-setPropertyName}{\code{bdpar::GenericPipe$setPropertyName()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{InterjectionPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$new(
  propertyName = "interjection",
  propertyLanguageName = "language",
  alwaysBeforeDeps = list("GuessLanguagePipe"),
  notAfterDeps = list(),
  removeInterjections = TRUE,
  resourcesInterjectionsPath = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{propertyLanguageName}}{A \code{\link{character}} value. Name of the
language property.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{removeInterjections}}{A \code{\link{logical}} value. Indicates if
the interjections are removed or not.}

\item{\code{resourcesInterjectionsPath}}{A \code{\link{character}} value. Path
of resource files (in json format) containing the interjections.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain/remove
the interjections. The interjections found in the data are added to the
list of properties of the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-findInterjection"></a>}}
\if{latex}{\out{\hypertarget{method-findInterjection}{}}}
\subsection{Method \code{findInterjection()}}{
Checks if the interjection is in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$findInterjection(data, interjection)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text where interjection
will be searched.}

\item{\code{interjection}}{A \code{\link{character}} value. Indicates the
interjection to find.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{logical}} value depending on whether the
interjection is in the data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeInterjection"></a>}}
\if{latex}{\out{\hypertarget{method-removeInterjection}{}}}
\subsection{Method \code{removeInterjection()}}{
Removes the \emph{interjection} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$removeInterjection(interjection, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interjection}}{A \code{\link{character}} value. Indicates the
interjection to remove.}

\item{\code{data}}{A \code{\link{character}} value. The text where interjection
will be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data with the interjections removed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPropertyLanguageName"></a>}}
\if{latex}{\out{\hypertarget{method-getPropertyLanguageName}{}}}
\subsection{Method \code{getPropertyLanguageName()}}{
Gets the name of property language.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$getPropertyLanguageName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of name of property language.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getResourcesInterjectionsPath"></a>}}
\if{latex}{\out{\hypertarget{method-getResourcesInterjectionsPath}{}}}
\subsection{Method \code{getResourcesInterjectionsPath()}}{
Gets the path of interjections resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$getResourcesInterjectionsPath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of path of interjections resources.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setResourcesInterjectionsPath"></a>}}
\if{latex}{\out{\hypertarget{method-setResourcesInterjectionsPath}{}}}
\subsection{Method \code{setResourcesInterjectionsPath()}}{
Sets the path of interjections resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$setResourcesInterjectionsPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. The new value of the path of
interjections resources.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterjectionPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
