% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{get_report}
\alias{get_report}
\alias{get_report.plm0}
\alias{get_report.plm}
\alias{get_report.gplm0}
\alias{get_report.gplm}
\alias{get_report.tournament}
\title{Report for a discharge rating curve or tournament}
\usage{
get_report(x, path = NULL, type = 1, ...)

\method{get_report}{plm0}(x, path = NULL, type = 1, ...)

\method{get_report}{plm}(x, path = NULL, type = 1, ...)

\method{get_report}{gplm0}(x, path = NULL, type = 1, ...)

\method{get_report}{gplm}(x, path = NULL, type = 1, ...)

\method{get_report}{tournament}(x, path = NULL, type = 1, ...)
}
\arguments{
\item{x}{an object of class "tournament", "plm0", "plm", "gplm0" or "gplm".}

\item{path}{file path to which the pdf file of the report is saved. If NULL, the current working directory is used.}

\item{type}{an integer denoting what type of report is to be produced. Defaults to type 1. Only type 1 is permissible for an object of class "plm0", "plm", "gplm0" or "gplm". Possible types are
\itemize{
   \item{1 - }{produces a report displaying the results of the model (winning model if a tournament provided). The first page contains a panel of four plots and a summary of the posterior distributions of the parameters. On the second page a tabular prediction of discharge on an equally spaced grid of stages is displayed. This prediction table can span multiple pages.}
   \item{2 - }{produces a ten page report and is only permissible for objects of class "tournament". The first four pages contain a panel of four plots and a summary of the posterior distributions of the parameters for each of the four models in the tournament, the fifth page shows model comparison plots and tables, the sixth page convergence diagnostics plots, and the final four pages shows the histograms of the parameters in each of the four models.}
}}

\item{...}{further arguments passed to other methods (currently unused).}
}
\value{
No return value, called for side effects
}
\description{
Save a pdf file with a report of a discharge rating curve object or tournament.
}
\details{
This function can only be used in an interactive R session as it asks permission from the user to write to their file system.
}
\section{Methods (by class)}{
\itemize{
\item \code{plm0}: Get report for plm0 model object

\item \code{plm}: Get report for plm model object

\item \code{gplm0}: Get report for gplm0 model object

\item \code{gplm}: Get report for gplm

\item \code{tournament}: Get report for discharge rating curve tournament
}}

\examples{
\donttest{
data(krokfors)
set.seed(1)
plm0.fit <- plm0(formula=Q~W,data=krokfors,num_cores=2)
}
\dontrun{
get_report(plm0.fit)
}
}
\seealso{
\code{\link{get_report}} for generating and saving a report.
}
