% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEM_matrices.R
\name{SEM_C_matrix}
\alias{SEM_C_matrix}
\title{Coefficients matrix for initial conditions}
\usage{
SEM_C_matrix(alpha, phi_0, periods_n, beta = c(), phi_1 = c())
}
\arguments{
\item{alpha}{numeric}

\item{phi_0}{numeric}

\item{periods_n}{numeric}

\item{beta}{numeric vector. Default is c() for no regressors case.}

\item{phi_1}{numeric vector. Default is c() for no regressors case.}
}
\value{
matrix
}
\description{
Create matrix for Simultaneous Equations Model (SEM)
representation with coefficients placed next to initial values
of regressors, dependent variable and country-specific time-invariant
variables.
}
\examples{
alpha <- 9
phi_0 <- 19
beta <- 11:15
phi_1 <- 21:25
periods_n <- 4
SEM_C_matrix(alpha, phi_0, periods_n, beta, phi_1)
}
