% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma.R
\name{bma}
\alias{bma}
\title{Calculation of the bma object}
\usage{
bma(model_space, df, round = 4, EMS = NULL, dilution = 0, dil.Par = 0.5)
}
\arguments{
\item{model_space}{List with params and stats from the model space}

\item{df}{Data frame with data for the SEM analysis.}

\item{round}{Parameter indicating the decimal place to which number in the BMA tables and prior and posterior model sizes should be rounded (default round = 4)}

\item{EMS}{Expected model size for model binomial and binomial-beta model prior}

\item{dilution}{Binary parameter: 0 - NO application of a dilution prior; 1 - application of a dilution prior (George 2010).}

\item{dil.Par}{Parameter associated with dilution prior - the exponent of the determinant (George 2010). Used only if parameter dilution = 1.}
}
\value{
A list with 16 elements.

\describe{
\item{uniform_table}{A table containing the results based on the binomialmodel prior.}
\item{random_table}{A table containing the results based on the binomial-beta model prior.}
\item{reg_names}{A vector containing the names of the regressors, used by the functions.}
\item{R}{The total number of regressors.}
\item{num_of_models}{The number of models present in the model space.}
\item{forJointnes}{A table containing model IDs and posterior model probabilities (PMPs) for the jointness function.}
\item{forBestModels}{A table containing model IDs, PMPs, coefficients, standard deviations,and standardized regression coefficients (stdRs) for the best_models function.}
\item{EMS}{The expected model size for the binomial and binomial-beta model priors, as specified by the user (default is EMS = R/2).}
\item{sizePriors}{A table of uniform and random model priors distributed over model sizes for the model_sizes function.}
\item{PMPs}{A table containing the posterior model probabilities for use in the model_sizes function.}
\item{modelPriors}{A table containing the model priors, used by the model_pmp function.}
\item{dilution}{A parameter indicating whether the priors were diluted, used in the model_sizes function.}
\item{alphas}{A vector of coefficients for the lagged dependent variable in the coef_hist function.}
\item{betas_nonzero}{A vector of nonzero coefficients for the regressors in the coef_hist function.}
\item{d_free}{A table containing the degrees of freedom for the estimated models in the best_models function.}
\item{PMStable}{A table containing the prior and posterior expected model sizes for the binomial and binomial-beta model priors.}
}
}
\description{
This function calculates BMA statistics based on the provided model space.
Other objects for furhter analysis are also returned.
}
\examples{
\donttest{
library(magrittr)

data_prepared <- bdsm::economic_growth[, 1:6] \%>\%
  bdsm::feature_standardization(
    excluded_cols = c(country, year, gdp)
  ) \%>\%
  bdsm::feature_standardization(
    group_by_col  = year,
    excluded_cols = country,
    scale         = FALSE
  )

bma_results <- bma(
  model_space = bdsm::small_model_space,
  df          = data_prepared,
  round       = 3,
  dilution    = 0
)
}
}
