% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bea2Tab.r
\name{bea2Tab}
\alias{bea2Tab}
\title{Convert BEA API httr response or list payload to data.table}
\usage{
bea2Tab(beaPayload, asWide = TRUE, iTableStyle = TRUE)
}
\arguments{
\item{beaPayload}{An object of class 'list' or httr 'response' returned from beaGet() call to BEA API}

\item{asWide}{Return data.table in wide format (default: TRUE)}

\item{iTableStyle}{If "asWide = TRUE", setting "iTableStyle = TRUE" will return data.table in same format as shown on BEA website, with dates and attributes as column headers and series as rows; otherwise, results have series codes as column headers (default: TRUE)}
}
\value{
An object of class 'data.table' containing data from beaGet(...) with custom attributes(BDT)$params.
}
\description{
Convert BEA API httr response or list payload to data.table. Also, converts LONG data frame (default API format - see bea2List results) to WIDE data (with years as columns) by default
}
\examples{
userSpecList <- list('UserID' = 'yourKey' ,
								'Method' = 'GetData',
								'datasetname' = 'NIPA',
								'Frequency' = 'A',
								'TableID' = '68',
								'Year' = 'X')
resp <- beaGet(userSpecList)
BDT <- bea2Tab(resp)
}
