% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_data_frame_analyte}
\alias{as_data_frame_analyte}
\title{Cast list of analytes to \code{data.frame}}
\usage{
as_data_frame_analyte(.analytes, .id_bead = "Bead group",
  .id_analyte = "Analyte ID")
}
\arguments{
\item{.analytes}{The named list to be cast. It usually is loaded using
\code{\link[=load_panel]{load_panel()}}. See Details for expected structure.}

\item{.id_bead, .id_analyte}{The name of the column to hold the bead group and the analyte ID, respectively.}
}
\value{
A \code{data-frame}
}
\description{
A well structured list, such at those loaded by \code{\link[=load_panel]{load_panel()}}, is cast to a data.frame.
}
\details{
Each analyte in the \code{list} passed to the function is expected to be a named
list with named elements \code{name} and \code{concentration}. The name of the \code{list}
with the analyte specific information is the analyte ID.

Because of the particular setup of the LEGENDplex assay with two bead groups,
the analytes are expected to be wrapped in another \code{list}.
}
\examples{
.analytes <-  list(A = list(
                A1 = list(name = "name_a1", concentration = 500),
                A2 = list(name = "name_a2", concentration = 50000)))

as_data_frame_analyte(.analytes)
}
