% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_analyte.R
\name{identify_analyte}
\alias{identify_analyte}
\title{Identify analyte}
\usage{
identify_analyte(.data, .parameter, .analyte_id,
  .column_name = "analyte", .k = length(.analyte_id), .trim = 0,
  .desc = FALSE, .method = c("clara", "kmeans", "dbscan", "mclust",
  "density_cut"), ...)
}
\arguments{
\item{.data}{A tidy data.frame.}

\item{.parameter}{A character giving the name of column(s) where populations
are identified.}

\item{.analyte_id}{A character vector giving the ID of the analyte.
The \strong{order} is important and must match the expected order of analytes.}

\item{.column_name}{A character giving the name of the column to store the
population information.}

\item{.k}{Numeric giving the number of expected clusters, or a set of initial
cluster centers.}

\item{.trim}{A numeric between 0 and 1, giving the fraction of points to
remove by marking them NA.}

\item{.desc}{A boolean to indicate if the centers of the analytes should be
arranged in a descending fashion before assigning the names.}

\item{.method}{A character giving the clustering method to use.}

\item{...}{Additional arguments passed to appropriate methods, see below.}
}
\value{
A data.frame with analyte IDs in a separate column
}
\description{
Identify analyte
}
\details{
This function is a wrapper around the process of:
\itemize{
\item Finding analyte clusters
\item Trimming the clusters by removing the cluster members most distant from
the cluster center
\item Sorting the analyte clusters based on their centers
\item Giving each analyte cluster a useful name
}
}
\section{Additional parameters}{



Information on additional arguments passed, can be found here:

\describe{
\item{clara}{\code{\link[cluster:clara]{cluster::clara()}}}
\item{kmeans}{\code{\link[=kmeans]{kmeans()}}}
\item{dbscan}{\code{\link[fpc:dbscan]{fpc::dbscan()}}}
\item{mclust}{\code{\link[mclust:Mclust]{mclust::Mclust()}}}
\item{density_cut}{\code{\link[=approx_adjust]{approx_adjust()}}}
}
}

\examples{
\dontrun{
library(beadplexr)
library(magrittr)
library(ggplot2)

data("lplex")

.data <- lplex[[1]]
.data \%>\%
  identify_analyte(.parameter = c("FSC-A", "SSC-A"),
                      .analyte_id = c("A", "B"),
                      .column_name = "analyte",
                      .method = "clara", .trim = 0.02) \%>\%
  ggplot() +
  aes(x = `FSC-A`, y = `SSC-A`, colour = analyte) +
  geom_point()

.data \%>\%
  identify_analyte(.parameter = c("FSC-A", "SSC-A"),
                      .analyte_id = c("A", "B"),
                      .column_name = "analyte",
                      .method = "clara", .desc = TRUE) \%>\%
  ggplot() +
  aes(x = `FSC-A`, y = `SSC-A`, colour = analyte) +
  geom_point()

.data \%>\%
  identify_analyte(.parameter = c("FSC-A", "SSC-A"),
                      .analyte_id = c("A", "B"),
                      .column_name = "analyte",
                      .method = "dbscan") \%>\%
  ggplot() +
  aes(x = `FSC-A`, y = `SSC-A`, colour = analyte) +
  geom_point()
}
}
\seealso{
\code{\link[=cluster_events]{cluster_events()}}
}
