% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fcs.R
\name{subset_channels}
\alias{subset_channels}
\title{Subset channels}
\usage{
subset_channels(.flow_frame, .filter = NULL)
}
\arguments{
\item{.flow_frame}{A \code{flowFrame}. Usually the result of \code{read.FCS}
from \code{flowCore}.}

\item{.filter}{An Optional list of upper and lower cutoff for individual
channels. Default is no filtering at all.}
}
\value{
A \code{FlowFrame} with border events removed.
}
\description{
A wrapper around the application of \code{flowCore}'s \code{rectangleGate}.
}
\examples{
\dontrun{
library(beadplexr)
library(flowCore)

.file_name <- system.file("extdata", "K2-C07-A7.fcs",
                            package = "beadplexr")
# Load the fcs file
 .flow_frame <- read.FCS(filename = .file_name,
                          transformation = FALSE)

 # Plot with all events
 all_events <- .flow_frame@exprs
 plot(all_events[, c("FSC-A", "SSC-A")])
 # Events are untransformed
 plot(all_events[, c("FL2-H", "FL6-H")])

 # A silly thing that does nothing
 .flow_frame <- subset_channels(.flow_frame)
 filter_1 <- .flow_frame@exprs
 plot(filter_1[, c("FSC-A", "SSC-A")])

 # Filter on forward scatter
 .flow_frame <- subset_channels(.flow_frame,
                                .filter = list("FSC-A" = c(1e3L, 2e6)))
 filter_2 <- .flow_frame@exprs
 plot(filter_2[, c("FSC-A", "SSC-A")])

 # Filter on forward and side scatter
 .flow_frame <- subset_channels(.flow_frame,
                                .filter = list("FSC-A" = c(2e5L, 6.5e5L),
                                                "SSC-A" = c(2e5, 1e6L)))
 filter_3 <- .flow_frame@exprs
 plot(filter_3[, c("FSC-A", "SSC-A")])

 # Filter on the unfiltered bead channels (please transform first)
 .flow_frame <- subset_channels(.flow_frame,
                                .filter = list("FL2-H" = c(5e4L, 6e5L),
                                               "FL6-H" = c(0, 3e5L)))
 filter_4 <- .flow_frame@exprs
 plot(filter_4[, c("FL2-H", "FL6-H")])

 # And everything at once
 .flow_frame <- read.FCS(filename = .file_name,
                        transformation = FALSE)
.flow_frame <- subset_channels(.flow_frame,
                               .filter = list("FSC-A" = c(2e5L, 6.5e5L),
                                              "SSC-A" = c(2e5, 1e6L),
                                              "FL2-H" = c(5e4L, 6e5L),
                                              "FL6-H" = c(0, 3e5L)))
filter_5 <- .flow_frame@exprs
plot(filter_5[, c("FSC-A", "SSC-A")])
plot(filter_5[, c("FL2-H", "FL6-H")])
}
}
\seealso{
\code{\link[flowCore]{rectangleGate}} for instructions to the
\code{.filter} list argument
}
\keyword{internal}
