% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_events.R
\name{trim_population}
\alias{trim_population}
\title{Trim cluster.}
\usage{
trim_population(.data, .parameter, .column_name = "population",
  .trim = 0.1)
}
\arguments{
\item{.data}{The tidy data.frame with clusters to be modified.}

\item{.parameter}{A character giving the name of dimensions to calculate
distance on.}

\item{.column_name}{A character giving the name of the column with the
cluster information.}

\item{.trim}{A numeric between 0 and 1, giving the fraction of points to
remove.}
}
\value{
A data.frame
}
\description{
Remove the points furthest form the center of the cluster.
}
\details{
The euclidean distance is calculated for each point defined by
\code{.parameter} to the center of the cluster. The cluster designation of
the \code{.trim} most distant points are changed to \code{NA}.
}
\examples{
library(beadplexr)
library(dplyr)
library(ggplot2)

data("lplex")

lplex[[1]] \%>\%
  filter(`FSC-A` > 3.2e5L) \%>\%
  mutate(population = "1") \%>\%
  trim_population(.parameter = c("FSC-A", "SSC-A"), .column_name = "population", .trim = 0.1) \%>\%
  ggplot() +
  aes(x = `FSC-A`, y = `SSC-A`, colour = population) +
  geom_point()

lplex[[1]] \%>\%
  filter(`FSC-A` > 3.2e5L) \%>\%
  mutate(population = as.character(1)) \%>\%
  trim_population(.parameter = c("FSC-A", "SSC-A"),
                  .column_name = "population", .trim = 0.8) \%>\%
  ggplot() +
  aes(x = `FSC-A`, y = `SSC-A`, colour = population) +
  geom_point()
}
