% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turning_points.R
\name{approx_adjust}
\alias{approx_adjust}
\title{Approximate bandwidth adjustment.}
\usage{
approx_adjust(.x, .k, .lower = 0.4, .upper = 2, .step = 0.2)
}
\arguments{
\item{.x}{A numeric vector.}

\item{.k}{Numeric giving the number of expected clusters.}

\item{.lower, .upper}{The interval for possible value of adjust.}

\item{.step}{A numeric giving the increment to adjust. Sometimes low values
are needed to find a proper adjust value.}
}
\value{
A numeric.
}
\description{
Approximates the adjust argument to \code{stats::density()} needed to find the required number of clusters.
}
\details{
This function finds the first value of the \code{\link[stats:density]{stats::density()}} \code{adjust}
argument which gives the \code{.k} number of clusters. It it quite crude in that
every value of adjust from \code{.lower} to \code{.upper} is tested until the desired
number of clusters is found. A cluster is defined by a peak, and should no
suitable \code{adjust} value be found, NA is returned.
}
\examples{

set.seed(1234)
.x <- c(rnorm(100, 2, 1), rnorm(100, 9, 1))
approx_adjust(.x, 2)
}
