#Generalized Linear Models (GLM)
GLManalyze<-function(TotalData, separateWindows=TRUE)
{
cat("****************************************************************************\n")
cat("*                      Generalized Linear Models (GLM)                     *\n")
cat("*--------------------------------------------------------------------------*\n")
cat("* A two-treatment, two-period, two-sequence (2x2) randomized crossover     *\n")
cat("* design, the statistical model includes factors accounting for the        *\n")
cat("* following sources of variation: sequence, subjects nested in sequences,  *\n")
cat("* period and treatment.  GLM was used to obtain estimates for the adjusted *\n")
cat("* differences between treatment means and the standard error associated    *\n")
cat("* with these differences.  Log-transformed BA measures were also analyzed. *\n")
cat("****************************************************************************\n")

cat("\nEnter NCA parameter data file name\n")
NCAname<-readline()
NCAname<-paste(NCAname,".RData",sep="")
load(NCAname)
show(TotalData)
cat("\n\n")
Fdata<-split(TotalData, list(TotalData$drug))
RefData<-Fdata[[1]]
TestData<-Fdata[[2]]

#represent GLM
cat("****************************************************************************\n")
cat("*                   General Linear Model Procedure                         *\n")          
cat("*--------------------------------------------------------------------------*\n")
cat("  Dependent Variable: Cmax                                                  \n")
cat("\n")
Cmax<- lm(Cmax ~ seq + subj + prd + drug , data=TotalData)
summary(Cmax)
show(anova(Cmax))
cat("\n")
cat(" Tests of Hypothese using the Type I MS for SUBJECT(SEQUENCE) as an error term\n")
cat("\n")
Cmax1<- lm(Cmax ~ seq , data=TotalData)
show(anova(Cmax1))
cat("****************************************************************************\n")

cat("\n")
cat("\n")
cat("****************************************************************************\n")
cat("*                   General Linear Model Procedure                         *\n")          
cat("*--------------------------------------------------------------------------*\n")
cat("  Dependent Variable: AUC0t                                                \n")
cat("\n")
AUC0t<- lm(AUC0t ~ seq + subj+ prd + drug , data=TotalData)
summary(AUC0t)
show(anova(AUC0t))
cat("\n")
cat(" Tests of Hypothese using the Type I MS for SUBJECT(SEQUENCE) as an error term\n")
cat("\n")
AUC0t1<- lm(AUC0t ~ seq , data=TotalData)
show(anova(AUC0t1))
cat("****************************************************************************\n")

cat("\n")
cat("\n")
cat("****************************************************************************\n")
cat("*                   General Linear Model Procedure                         *\n")          
cat("*--------------------------------------------------------------------------*\n")
cat("  Dependent Variable: AUC0inf                                               \n")
cat("\n")
AUC0INF<- lm(AUC0INF ~ seq + subj+ prd + drug , data=TotalData)
summary(AUC0INF)
show(anova(AUC0INF))
cat("\n")
cat(" Tests of Hypothese using the Type I MS for SUBJECT(SEQUENCE) as an error term\n")
cat("\n")
AUC0INF1<- lm(AUC0INF ~ seq , data=TotalData)
show(anova(AUC0INF1))
cat("****************************************************************************\n")

cat("\n")
cat("\n")
cat("****************************************************************************\n")
cat("*                   General Linear Model Procedure                         *\n")          
cat("*--------------------------------------------------------------------------*\n")
cat("  Dependent Variable: LnCmax                                               \n")
cat("\n")
LnCmax<- lm(LnCmax ~ seq + subj + prd + drug , data=TotalData)
summary(LnCmax)
show(anova(LnCmax))
cat("\n")
cat(" Tests of Hypothese using the Type I MS for SUBJECT(SEQUENCE) as an error term\n")
cat("\n")
LnCmax1<- lm(LnCmax ~ seq , data=TotalData)
show(anova(LnCmax1))
cat("****************************************************************************\n")

cat("\n")
cat("\n")
cat("****************************************************************************\n")
cat("*                   General Linear Model Procedure                         *\n")          
cat("*--------------------------------------------------------------------------*\n")
cat("  Dependent Variable: LnAUC0t                                               \n")
cat("\n")
LnAUC0t<- lm(LnAUC0t ~ seq + subj + prd + drug , data=TotalData)
summary(LnAUC0t)
show(anova(LnAUC0t))
cat("\n")
cat(" Tests of Hypothese using the Type I MS for SUBJECT(SEQUENCE) as an error term\n")
cat("\n")
LnAUC0t1<- lm(LnAUC0t ~ seq , data=TotalData)
show(anova(LnAUC0t1))
cat("****************************************************************************\n")

cat("\n")
cat("\n")
cat("****************************************************************************\n")
cat("*                   General Linear Model Procedure                         *\n")          
cat("*--------------------------------------------------------------------------*\n")
cat("  Dependent Variable: LnAUC0inf                                             \n")
cat("\n")
LnAUC0INF<- lm(LnAUC0INF ~ seq + subj + prd + drug , data=TotalData)
summary(LnAUC0INF)
show(anova(LnAUC0INF))
cat("\n")
cat(" Tests of Hypothese using the Type I MS for SUBJECT(SEQUENCE) as an error term\n")
cat("\n")
LnAUC0INF1<- lm(LnAUC0INF ~ seq , data=TotalData)
show(anova(LnAUC0INF1))
cat("****************************************************************************\n")
########REPORT
#L1(Reference-->Test),L2(Test-->Reference sequence)
SeqLeg<-split(RefData, list(RefData$seq))
L1<-length(SeqLeg[[1]]$seq)
L2<-length(SeqLeg[[2]]$seq)
T<-qt(0.95,(L1+L2-2))

ref_Cmax<-mean(RefData$LnCmax)
ref_AUC0t<-mean(RefData$LnAUC0t)
ref_AUC0INF<-mean(RefData$LnAUC0INF)

test_Cmax<-mean(TestData$LnCmax)
test_AUC0t<-mean(TestData$LnAUC0t)
test_AUC0INF<-mean(TestData$LnAUC0INF)

SE_Cmax<-sqrt((anova(LnCmax)[5,3]/2) * (1/L1+1/L2)) 
SE_AUC0t<-sqrt((anova(LnAUC0t)[5,3]/2) * (1/L1+1/L2))
SE_AUC0INF<-sqrt((anova(LnAUC0INF)[5,3]/2) * (1/L1+1/L2)) 

Z_Cmax<-0.2*(ref_Cmax/SE_Cmax)-qnorm(0.95)
Z_AUC0t<-0.2*(ref_AUC0t/SE_AUC0t)-qnorm(0.95)
Z_AUC0INF<-0.2*(ref_AUC0INF/SE_AUC0INF)-qnorm(0.95)

T_Cmax<-0.2*(ref_Cmax/SE_Cmax)-qt(0.975,L1+L2-2)
T_AUC0t<-0.2*(ref_AUC0t/SE_AUC0t)-qt(0.975,L1+L2-2)
T_AUC0INF<-0.2*(ref_AUC0INF/SE_AUC0INF)-qt(0.975,L1+L2-2)

cat("\n")
cat("\n")
cat("****************************************************************************\n")
cat("*                        Cross-over Design Report                          *\n")          
cat("*--------------------------------------------------------------------------*\n")
cat("  Dependent Variable: LnCmax                                               \n")
cat("*--------------------------------------------------------------------------*\n")
cat("n1(R=>T)=", L1 , "\n")
cat("n2(T=>R)=", L2 , "\n")
cat("N(n1+n2)=", L1+L2 , "\n")
cat("LSM-ref=", ref_Cmax, "\n")
cat("LSM-test=",test_Cmax, "\n")
cat("MSE=",anova(LnCmax)[5,3], "\n")
cat("SE=",SE_Cmax, "\n")
cat("Diff. (test-ref)=", test_Cmax-ref_Cmax, "\n")
cat("t(0.95,N-2)=",T , "\n")
cat("Z(beta)=",Z_Cmax, "\n")
cat("Power(1-beta)_Z=", pnorm(abs(Z_Cmax)),"\n")
cat("t(beta)=",T_Cmax, "\n")
cat("Power(1-beta)_t=", pt(T_Cmax,L1+L2-2) ,"\n")
cat("\n")
lowerCmax<-100*exp((test_Cmax-ref_Cmax)-(T*SE_Cmax))
upperCmax<-100*exp((test_Cmax-ref_Cmax)+(T*SE_Cmax))
cat("************************90% C.I. for LnCmax*********************************\n")
cat("90% CI Lower=", round(lowerCmax,3) ,"\n")
cat("90% CI Upper=", round(upperCmax,3) ,"\n")
if  (lowerCmax>80 && upperCmax<125)
 {
  cat("\n")
  cat("Bioequivalence= Pass!!!\n")
  }
  else{ 
   cat("\n") 
   cat("Bioequivalence= Fail!!!\n")
  }
cat("****************************************************************************\n")

cat("\n")
cat("\n")
cat("****************************************************************************\n")
cat("*                         Cross-over Design Report                         *\n")          
cat("*--------------------------------------------------------------------------*\n")
cat("  Dependent Variable: LnAUC0t                                               \n")
cat("*--------------------------------------------------------------------------*\n")
cat("n1(R=>T)=", L1 , "\n")
cat("n2(T=>R)=", L2 , "\n")
cat("N(n1+n2)=", L1+L2 , "\n")
cat("LSM-ref=", ref_AUC0t, "\n")
cat("LSM-test=",test_AUC0t, "\n")
cat("MSE=",anova(LnAUC0t)[5,3], "\n")
cat("SE=",SE_AUC0t, "\n")
cat("Diff. (test-ref)=", test_AUC0t-ref_AUC0t, "\n")
cat("t(0.95,N-2)=",T , "\n")
cat("Z(beta)=",Z_AUC0t, "\n")
cat("Power(1-beta)_Z=", pnorm(abs(Z_AUC0t)),"\n")
cat("t(beta)=",T_AUC0t, "\n")
cat("Power(1-beta)_t=",pt(T_AUC0t,L1+L2-2),"\n")
cat("\n")
lowerAUC0t<-100*exp((test_AUC0t-ref_AUC0t)-(T*SE_AUC0t))
UpperAUC0t<-100*exp((test_AUC0t-ref_AUC0t)+(T*SE_AUC0t))
cat("************************90% C.I. for LnAUC0t********************************\n")
cat("90% CI Lower=", round(lowerAUC0t,3) ,"\n")
cat("90% CI Upper=", round(UpperAUC0t,3) ,"\n")
if  (lowerAUC0t>80 && UpperAUC0t<125)
 {
  cat("\n")
  cat("Bioequivalence= Pass!!!\n")
  }
  else{ 
   cat("\n") 
   cat("Bioequivalence= Fail!!!\n")
  }
cat("****************************************************************************\n")

cat("\n")
cat("\n")
cat("****************************************************************************\n")
cat("*                           Cross-over Design Report                       *\n")          
cat("*--------------------------------------------------------------------------*\n")
cat("  Dependent Variable: LnAUC0inf                                            \n")
cat("*--------------------------------------------------------------------------*\n")
cat("n1(R=>T)=", L1 , "\n")
cat("n2(T=>R)=", L2 , "\n")
cat("N(n1+n2)=", L1+L2 , "\n")
cat("LSM-ref=", ref_AUC0INF, "\n")
cat("LSM-test=",test_AUC0INF, "\n")
cat("MSE=",anova(LnAUC0INF)[5,3], "\n")
cat("SE=",SE_AUC0INF, "\n")
cat("Diff. (test-ref)=", test_AUC0INF - ref_AUC0INF, "\n")
cat("t(0.95,N-2)=",T , "\n")
cat("Z(beta)=",Z_AUC0INF, "\n")
cat("Power(1-beta)_Z=",pnorm(abs(Z_AUC0INF)),"\n")
cat("t(beta)=",T_AUC0INF, "\n")
cat("Power(1-beta)_t=",pt(T_AUC0INF,L1+L2-2),"\n")
cat("\n")
LowerAUC0INF<-100*exp((test_AUC0INF - ref_AUC0INF)-(T*SE_AUC0INF))
UpperAUC0INF<-100*exp((test_AUC0INF - ref_AUC0INF)+(T*SE_AUC0INF))
cat("************************90% C.I. for LnAUC0inf******************************\n")
cat("90% CI Lower=", round(LowerAUC0INF,3) ,"\n")
cat("90% CI Upper=", round(UpperAUC0INF,3) ,"\n")
if  (LowerAUC0INF>80 && UpperAUC0INF<125)
 {
  cat("\n")
  cat("Bioequivalence= Pass!!!\n")
  }
  else{ 
   cat("\n") 
   cat("Bioequivalence= Fail!!!\n")
  }
cat("****************************************************************************\n")

GLMoutput(RefData, TestData, TotalData)
bye()
}