% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_default_beast2_jar_path.R
\name{get_default_beast2_jar_path}
\alias{get_default_beast2_jar_path}
\title{Get the default BEAST2 jar file's path}
\usage{
get_default_beast2_jar_path(os = rappdirs::app_dir()$os)
}
\arguments{
\item{os}{name of the operating system,
must be \code{unix} (Linux, Mac) or \code{win} (Windows)}
}
\value{
the default BEAST2 jar file's path
}
\description{
Get the default BEAST2 jar file's path
}
\examples{
  library(testthat)

  if (is_beast2_installed() && rappdirs::app_dir()$os == "unix") {
    expect_true(
      grepl(
        "beast/lib/beast.jar",
        get_default_beast2_jar_path()
      )
    )
  }
}
\seealso{
Use \link{get_default_beast2_folder} to get the default
  folder in which BEAST2 is installed.
  Use \link{install_beast2} with default arguments
  to install BEAST2 to this location.
}
\author{
Richèl J.C. Bilderbeek
}
