% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_can_create_file.R
\name{check_can_create_file}
\alias{check_can_create_file}
\title{Internal function}
\usage{
check_can_create_file(filename, overwrite = TRUE)
}
\arguments{
\item{filename}{file that may or may not be created}

\item{overwrite}{if TRUE, if \code{filename} already exists, it
will be deleted by this function}
}
\value{
Nothing.
Will \link{stop} if a file cannot be created at a certain path.
}
\description{
Check that a file can be created at a certain path.
}
\details{
Will \link{stop} if not. Will \link{stop} if the file already exists.
Does so by creating an empty file at the path,
and then deleting it.
}
\examples{
check_can_create_file("my_local_file.txt")
}
\author{
Richèl J.C. Bilderbeek
}
