% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_inv_gamma_distr}
\alias{create_inv_gamma_distr}
\alias{create_distr_inv_gamma}
\title{Create an inverse gamma distribution}
\usage{
create_inv_gamma_distr(id = NA, alpha = create_alpha_param(),
  beta = create_beta_param())
}
\arguments{
\item{id}{the distribution's ID}

\item{alpha}{the alpha shape parameter,
as returned by \code{\link{create_alpha_param}}}

\item{beta}{the beta shape parameter,
as returned by \code{\link{create_beta_param}}}
}
\value{
an inverse gamma distribution
}
\description{
Create an inverse gamma distribution
}
\examples{
  inv_gamma_distr <- create_inv_gamma_distr()

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "my_beast.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = inv_gamma_distr
    )
  )
  testit::assert(file.exists("my_beast.xml"))
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richel J.C. Bilderbeek
}
