% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_laplace_distr}
\alias{create_laplace_distr}
\alias{create_distr_laplace}
\title{Create a Laplace distribution}
\usage{
create_laplace_distr(id = NA, mu = create_mu_param(id = NA, estimate =
  FALSE, value = 0), scale = create_scale_param(id = NA, estimate = FALSE,
  value = 1))
}
\arguments{
\item{id}{the distribution's ID}

\item{mu}{the mu parameter,
as returned by \code{\link{create_mu_param}}}

\item{scale}{the scale parameter,
as returned by \code{\link{create_scale_param}}}
}
\value{
a Laplace distribution
}
\description{
Create a Laplace distribution
}
\examples{
  laplace_distr <- create_laplace_distr()

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_laplace_distr.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = laplace_distr
    )
  )
  testit::assert(file.exists("create_laplace_distr.xml"))
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richel J.C. Bilderbeek
}
