% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_log_normal_distr}
\alias{create_log_normal_distr}
\alias{create_distr_log_normal}
\title{Create a log-normal distribution}
\usage{
create_log_normal_distr(id = NA, m = create_m_param(),
  s = create_s_param())
}
\arguments{
\item{id}{the distribution's ID}

\item{m}{the m parameter,
as returned by \code{\link{create_m_param}}}

\item{s}{the s parameter,
as returned by \code{\link{create_s_param}}}
}
\value{
a log-normal distribution
}
\description{
Create a log-normal distribution
}
\examples{
  log_normal_distr <- create_log_normal_distr()

  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "my_beast.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = log_normal_distr
    )
  )
  testit::assert(file.exists("my_beast.xml"))
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richel J.C. Bilderbeek
}
