% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_misc_options.R
\name{create_misc_options}
\alias{create_misc_options}
\title{Function to create a misc_options, containing miscellaneous options
  to fine-tune the created BEAST2 XML file. Whatever option chosen
  here, the created XML file will be valid.}
\usage{
create_misc_options(capitalize_first_char_id = FALSE,
  nucleotides_uppercase = FALSE)
}
\arguments{
\item{capitalize_first_char_id}{must the ID of alignment start with a
capital? TRUE if yes, FALSE if it can be left lower case (if it is
lowercase)}

\item{nucleotides_uppercase}{must the nucleotides of the DNA sequence be
in uppercase?}
}
\value{
a misc_options
}
\description{
Function to create a misc_options, containing miscellaneous options
  to fine-tune the created BEAST2 XML file. Whatever option chosen
  here, the created XML file will be valid.
}
\examples{
  misc_options <- create_misc_options(nucleotides_uppercase = TRUE)
  xml <- create_beast2_input(
    get_fasta_filename(),
    misc_options = misc_options
  )
  testit::assert(is.character(xml))
  testit::assert(length(xml) > 1)
}
\author{
Richel J.C. Bilderbeek
}
