% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_site_model_n_distrs.R
\name{get_site_model_n_distrs}
\alias{get_site_model_n_distrs}
\title{Get the number of distributions a site model has}
\usage{
get_site_model_n_distrs(site_model)
}
\arguments{
\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}
}
\value{
the number of distributions a site model has
}
\description{
Get the number of distributions a site model has
}
\examples{
  # gamma site model, rates AC, AG, AT, CG and GT
  testit::assert(
    beautier:::get_site_model_n_distrs(create_gtr_site_model()) == 6
  )

  # gamma site model, kappa
  testit::assert(
    beautier:::get_site_model_n_distrs(create_hky_site_model()) == 2
  )

  # gamma site model
  testit::assert(
    beautier:::get_site_model_n_distrs(create_jc69_site_model()) == 1
  )

  # gamma site model, kappa 1 and kappa 2
  testit::assert(
    beautier:::get_site_model_n_distrs(create_tn93_site_model()) == 3
  )
}
\author{
Richel J.C. Bilderbeek
}
