% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_mcmc_nested_sampling.R
\name{create_nested_sampling_mcmc}
\alias{create_nested_sampling_mcmc}
\alias{create_mcmc_nested_sampling}
\title{Create an MCMC object to estimate the marginal likelihood
using Nested Sampling.}
\usage{
create_nested_sampling_mcmc(chain_length = 1e+07, store_every = -1,
  particle_count = 1, sub_chain_length = 5000, epsilon = "1e-12")
}
\arguments{
\item{chain_length}{upper bound to the length of the MCMC chain}

\item{store_every}{number of states the MCMC will process
before the posterior's state will be saved to file.
Use -1 or \code{NA} to use the default frequency.}

\item{particle_count}{number of particles}

\item{sub_chain_length}{sub-chain length}

\item{epsilon}{epsilon}
}
\value{
an MCMC object
}
\description{
This will result in a BEAST run that estimates the marginal
likelihood until convergence is achieved.
In this context, \code{chain_length} is only an upper bound
to the length of that run.
}
\examples{
  mcmc <- create_mcmc_nested_sampling(
    chain_length = 1e7,
    store_every = 1000,
    particle_count = 1,
    sub_chain_length = 1000,
    epsilon = 1e-12
  )

  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    get_fasta_filename(),
    beast2_input_file,
    mcmc = mcmc
  )
  testit::assert(file.exists(beast2_input_file))
}
\references{
* [1] Patricio Maturana Russel, Brendon J Brewer, Steffen Klaere,
    Remco R Bouckaert; Model Selection and Parameter Inference in
    Phylogenetics Using Nested Sampling, Systematic Biology, 2018,
    syy050, https://doi.org/10.1093/sysbio/syy050
}
\seealso{
Use \code{\link{create_nested_sampling_mcmc}} to create a
  nested sampling MCMC
}
\author{
Richèl J.C. Bilderbeek
}
