% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_equal_screenlogs.R
\name{are_equal_screenlogs}
\alias{are_equal_screenlogs}
\title{Determine if two screenlogs are equal.}
\usage{
are_equal_screenlogs(screenlog_1, screenlog_2)
}
\arguments{
\item{screenlog_1}{an screenlog, as created by \link{create_screenlog}}

\item{screenlog_2}{an screenlog, as created by \link{create_screenlog}}
}
\value{
TRUE if the two screenlogs are equal
}
\description{
Will \link{stop} if the arguments are not screenlogs.
}
\examples{
library(testthat)

screenlog_1 <- create_screenlog(log_every = 1000)
screenlog_2 <- create_screenlog(log_every = 314)
expect_true(are_equal_screenlogs(screenlog_1, screenlog_1))
expect_false(are_equal_screenlogs(screenlog_1, screenlog_2))
}
\seealso{
Use \link{create_screenlog} to create an screenlog
}
\author{
Richèl J.C. Bilderbeek
}
