% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_file_exists.R
\name{check_file_exists}
\alias{check_file_exists}
\title{Function to check if a file exists.
Calls \code{stop} if the file is absent}
\usage{
check_file_exists(filename, filename_description = NA)
}
\arguments{
\item{filename}{name of the file}

\item{filename_description}{description of the filename}
}
\value{
nothing. Will \code{stop} if the file is absent,
  with a proper error message
}
\description{
Function to check if a file exists.
Calls \code{stop} if the file is absent
}
\examples{
library(testthat)

expect_silent(
  check_file_exists(
    get_beautier_path("anthus_aco_sub.fas")
  )
)

# Minimal use
expect_error(
  check_file_exists("absent"),
  "File not found. Could not find file with path 'absent'"
)

# Add a description
absent_filename <- "absent"
expect_error(
  check_file_exists(absent_filename, "absent_filename"),
  "File 'absent_filename' not found. Could not find file with path 'absent'"
)
}
\author{
Richèl J.C. Bilderbeek
}
