% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrca_prior_to_xml_state.R
\name{mrca_prior_to_xml_state}
\alias{mrca_prior_to_xml_state}
\title{Internal function to create the XML of an MRCA prior,
  as used in the \code{state} section}
\usage{
mrca_prior_to_xml_state(
  inference_model,
  mrca_prior = "deprecated",
  has_non_strict_clock_model = "deprecated"
)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}

\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{has_non_strict_clock_model}{boolean to indicate that the is
already at least one non-strict (i.e. relaxed log-normal) clock model}
}
\value{
the tree prior as XML text
}
\description{
Internal function to create the XML of an MRCA prior,
  as used in the \code{state} section
}
\examples{
library(testthat)

created <- mrca_prior_to_xml_state(
  inference_model = create_inference_model(
    mrca_prior = create_mrca_prior(
      alignment_id = "test_output_0",
      mrca_distr = create_normal_distr(id = 42)
    ),
    clock_model = create_strict_clock_model()
  )
)
expect_match(created, "<parameter id=\"clockRate.c:")
}
\author{
Richèl J.C. Bilderbeek
}
