% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input.R
\name{create_beast2_input}
\alias{create_beast2_input}
\title{Create a BEAST2 XML input text}
\usage{
create_beast2_input(
  input_filename,
  tipdates_filename = NA,
  site_model = beautier::create_jc69_site_model(),
  clock_model = beautier::create_strict_clock_model(),
  tree_prior = beautier::create_yule_tree_prior(),
  mrca_prior = NA,
  mcmc = beautier::create_mcmc(),
  beauti_options = beautier::create_beauti_options(),
  input_filenames = "deprecated",
  site_models = "deprecated",
  clock_models = "deprecated",
  tree_priors = "deprecated",
  mrca_priors = "deprecated",
  posterior_crown_age = "deprecated"
)
}
\arguments{
\item{input_filename}{A FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{tipdates_filename}{name of the file containing the tip dates.
This file is assumed to have two columns, separated by a tab.
The first column contains the taxa names, the second column contains
the date.}

\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}

\item{clock_model}{a clock model,
as returned by \code{\link{create_clock_model}}}

\item{tree_prior}{a tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{mcmc}{one MCMC.
Use \code{\link{create_mcmc}} to create an MCMC.
Use \code{\link{create_ns_mcmc}} to create an MCMC
  for a Nested Sampling run.
Use \code{\link{check_mcmc}} to check if an MCMC is valid.
Use \code{\link{rename_mcmc_filenames}} to rename the filenames in an MCMC.}

\item{beauti_options}{one BEAUti options object,
as returned by \code{\link{create_beauti_options}}}

\item{input_filenames}{One or more FASTA filenames.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{tree_priors}{one or more tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}

\item{posterior_crown_age}{deprecated}
}
\value{
a character vector of XML strings
}
\description{
Create a BEAST2 XML input text
}
\examples{
  text <- create_beast2_input(
    input_filename = get_fasta_filename()
  )
  testit::assert(substr(text[1], 1, 5) == "<?xml")
  text[1]
  testit::assert(tail(text, n = 1) == "</beast>")
}
\seealso{
Use \link{create_beast2_input_from_model} to create the BEAST2 XML
  input text from an inference model
  Use \link{create_beast2_input_file} to also save it to file.

\code{\link{create_beast2_input_file}} shows more examples
}
\author{
Richèl J.C. Bilderbeek
}
