% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_crown_age.R
\name{get_crown_age}
\alias{get_crown_age}
\title{Obtain the crown age of a phylogeny.}
\usage{
get_crown_age(phylogeny)
}
\arguments{
\item{phylogeny}{The phylogeny to obtain the crown age of}
}
\value{
the crown age of the phylogeny
}
\description{
The crown age of a phylogeny is the time between
the present and the moment of at which the first
diversification (resulting in two lineages) happened.
}
\examples{
check_empty_beautier_folder()

phylogeny <- ape::read.tree(text = "(a:15,b:15):1;")
get_crown_age(phylogeny = phylogeny)

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
