#' Creates the \code{init} section of a BEAST2 XML parameter file
#' @inheritParams default_params_doc
#' @return lines of XML text
#' @author Richèl J.C. Bilderbeek
#' @examples
#' check_empty_beautier_folder()
#'
#' inference_model <- init_inference_model(
#'   input_filename = get_fasta_filename(),
#'   inference_model = create_test_inference_model()
#' )
#' xml <- create_beast2_input_init(
#'   inference_model = inference_model
#' )
#'
#' check_empty_beautier_folder()
#' @export
create_beast2_input_init <- function(
  inference_model
) {
  # Do not be smart yet
  ids <- inference_model$site_model$id
  testit::assert(length(ids) == 1)
  testit::assert(beautier::are_ids(ids))

  text <- NULL

  # From https://www.beast2.org/fix-starting-tree/:
  #
  # if there is an initaliser generated by BEAUti of the form
  #
  #   <init estimate="false" id="RandomTree.t:xxx" initial="@Tree.t:xxx"
  #     spec="beast.evolution.tree.RandomTree" taxa="@xxx">
  #   </init>
  #
  # remove this element from the file, otherwise the tree will be Newick tree
  #   will be overwritten by a random tree.
  #
  # In other words: bluntly remove it
  n <- length(ids)
  for (i in seq(1, n)) {
    text <- c(text, "")
    text <- c(
      text,
      beautier::indent(beautier::rnd_phylo_to_xml_init(inference_model))
    )
  }
  text
}
