% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_scale_param}
\alias{create_scale_param}
\alias{create_param_scale}
\title{Create a parameter called scale}
\usage{
create_scale_param(id = NA, value = 0)
}
\arguments{
\item{id}{the parameter's ID}

\item{value}{value of the parameter}
}
\value{
a parameter called scale
}
\description{
Create a parameter called scale
}
\note{
this parameter is used in a Laplace distribution
  (as returned by \code{\link{create_laplace_distr}})
}
\examples{
check_empty_beautier_folder()

# Create the parameter
scale_param <- create_scale_param()

# Use the parameter in a distribution
laplace_distr <- create_laplace_distr(
  scale = scale_param
)

# Use the distribution to create a BEAST2 input file
beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  beast2_input_file,
  tree_prior = create_yule_tree_prior(
    birth_rate_distr = laplace_distr
  )
)
file.remove(beast2_input_file)

remove_beautier_folder()
check_empty_beautier_folder()
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richèl J.C. Bilderbeek
}
