% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_init_site_model.R
\name{is_init_jc69_site_model}
\alias{is_init_jc69_site_model}
\title{Determine if x is an initialized JC69 site model
as created by \code{\link{create_jc69_site_model}}}
\usage{
is_init_jc69_site_model(x)
}
\arguments{
\item{x}{the object to check if it is an
initialized JC69 site model}
}
\value{
TRUE if x is an initialized JC69 site model
}
\description{
Determine if x is an initialized JC69 site model
as created by \code{\link{create_jc69_site_model}}
}
\examples{
check_empty_beautier_folder()

jc69_site_model <- create_jc69_site_model(
  gamma_site_model = create_gamma_site_model(
    gamma_cat_count = 2,
    gamma_shape_prior_distr = create_normal_distr()
  )
)
# FALSE: not yet initialized
is_init_jc69_site_model(jc69_site_model)
jc69_site_model <- init_jc69_site_model(jc69_site_model)
# TRUE: now it is initialized
is_init_jc69_site_model(jc69_site_model)

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
