% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_rate_ac_param}
\alias{create_rate_ac_param}
\alias{create_param_rate_ac}
\title{Create a parameter called 'rate AC'}
\usage{
create_rate_ac_param(id = NA, estimate = TRUE, value = "1.0", lower = "0.0")
}
\arguments{
\item{id}{the parameter's ID}

\item{estimate}{TRUE if this parameter is to be estimated by BEAST2,
FALSE otherwise}

\item{value}{value of the parameter}

\item{lower}{lowest possible value of the parameter. If the parameter
is estimated, \code{lower} must be less than \code{value}}
}
\value{
a parameter called 'rate AC'
}
\description{
Create a parameter called 'rate AC'
}
\examples{
if (is_on_ci()) {

  # Create parameter
  rate_ac_param <- create_rate_ac_param(value = 1, estimate = FALSE)

  # Use the parameter to create a BEAST2 input file
  beast2_input_file <- get_beautier_tempfilename()
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    site_model = create_gtr_site_model(
      rate_ac_param = rate_ac_param
    )
  )
  file.remove(beast2_input_file)

  remove_beautier_folder()
}
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richèl J.C. Bilderbeek
}
