% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_site_model_xml.R
\name{create_site_model_xml}
\alias{create_site_model_xml}
\title{Internal function to creates the XML text for the \code{siteModel} tag
of a BEAST2 parameter file.}
\usage{
create_site_model_xml(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
the site model as XML text
}
\description{
Creates the XML text for the \code{siteModel} tag of
a BEAST2 parameter file,
which is part of the \code{distribution} node for the
\code{treeLikelihood} ID.
}
\details{
The \code{siteModel} tag has these elements:

\preformatted{
  <siteModel[...]>

      [parameters]

      <substModel[...]>
        [...]
      </substModel>
  </siteModel>
}

The \code{parameter} section is created by
\link{create_site_model_parameters_xml}
The \code{substModel} section is created by \link{create_subst_model_xml}
}
\examples{
check_empty_beautier_folder()
 # <distribution id="posterior"[...]">
 #     <distribution id="likelihood" [...]>
 #       <siteModel...>
 #         [parameters]
 #       </siteModel>
 #     </distribution>
 # </distribution>

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
