% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_marginal_effect.R
\name{get_marginal_effect}
\alias{get_marginal_effect}
\title{Estimate marginal treatment effects using a GLM working model}
\usage{
get_marginal_effect(
  object,
  trt,
  strata = NULL,
  method = "Ge",
  type = "HC0",
  contrast = "diff",
  reference,
  mod = FALSE
)
}
\arguments{
\item{object}{a fitted \link[stats]{glm} object.}

\item{trt}{a string specifying the name of the treatment variable
in the model formula. It must be one of the linear predictor variables used
in fitting the \code{object}.}

\item{strata}{an optional string or vector of strings specifying the names
of stratification variables. Relevant only for Ye's method and used to
adjust the variance-covariance estimation for stratification.
If provided, each specified variable must be present in the model.}

\item{method}{a string indicating the chosen method for variance estimation.
Supported methods are \code{Ge} and \code{Ye}. The default method is \code{Ge} based on Ge
et al (2011) which is suitable for the variance estimation of conditional
average treatment effect. The method \code{Ye} is based on Ye et al (2023) and is
suitable for the variance estimation of population average treatment effect.
For more details, see \href{https://osf.io/9mp58/}{Magirr et al. (2024)}.}

\item{type}{a string indicating the type of
variance estimator to use (only applicable for Ge's method). Supported types include HC0 (default),
model-based, HC3, HC, HC1, HC2, HC4, HC4m, and HC5. See \link[sandwich]{vcovHC} for heteroscedasticity-consistent estimators.}

\item{contrast}{a string indicating choice of contrast. Defaults to 'diff' for a risk difference. See \link[beeca]{apply_contrast}.}

\item{reference}{a string indicating which treatment group should be considered as
the reference level. Accepted values are one of the levels in the treatment
variable. Default to the first level used in the \code{glm} object. This parameter influences the calculation of treatment effects
relative to the chosen reference group.}

\item{mod}{for Ye's method, the implementation of open-source RobinCar package
has an additional variance decomposition step when estimating the robust variance,
which then utilizes different counterfactual outcomes than the original reference.
Set \code{mod = TRUE} to use exactly the implementation method described in
Ye et al (2022), default to \code{FALSE} to use the modified implementation in
RobinCar and Bannick et al (2023) which improves stability.}
}
\value{
an updated \code{glm} object appended with marginal estimate components:
counterfactual.predictions (see \link[beeca]{predict_counterfactuals}),
counterfactual.means (see \link[beeca]{average_predictions}),
robust_varcov (see \link[beeca]{estimate_varcov}),
marginal_est, marginal_se (see \link[beeca]{apply_contrast}) and marginal_results. A summary is shown below
\tabular{ll}{
counterfactual.predictions \tab Counterfactual predictions based on the working model. For each subject in the input glm data, the potential outcomes are obtained by assigning subjects to each of the possible treatment variable levels. Each prediction is associated with a descriptive label explaining the counterfactual scenario. \cr
counterfactual.means       \tab Average of the counterfactual predictions for each level of the treatment variable. \cr
robust_varcov              \tab Variance-covariance matrix of the marginal effect estimate for each level of treatment variable, with estimation method indicated in the attributes.\cr
marginal_est               \tab Marginal treatment effect estimate for a given contrast.\cr
marginal_se                \tab Standard error estimate of the marginal treatment effect estimate. \cr
marginal_results           \tab Analysis results data (ARD) containing a summary of the analysis for subsequent reporting. \cr
}
}
\description{
Estimates the marginal treatment effect from a logistic regression working model
using a specified choice of variance estimator and contrast.
}
\details{
The \code{get_marginal_effect} function is a wrapper that facilitates
advanced variance estimation techniques for GLM models with covariate adjustment
targeting a population average treatment effect. It is particularly useful in clinical trial analysis
and other fields requiring robust statistical inference.
It allows researchers to account for complex study designs,
including stratification and treatment contrasts, by providing a flexible
interface for variance-covariance estimation.
}
\examples{
trial01$trtp <- factor(trial01$trtp)
fit1 <- glm(aval ~ trtp + bl_cov, family = "binomial", data = trial01) |>
  get_marginal_effect(trt = "trtp", method = "Ye", contrast = "diff", reference = "0")
fit1$marginal_results
}
