% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{FitMeanCurves}
\alias{FitMeanCurves}
\title{Fit Pooled Curves}
\usage{
FitMeanCurves(dat, equation, k, remq0e = FALSE, replfree = NULL,
  rem0 = FALSE, nrepl = NULL, replnum = NULL, plotcurves = FALSE,
  method = NULL, indpoints = TRUE, vartext = NULL)
}
\arguments{
\item{dat}{data frame (long form) of purchase task data.}

\item{equation}{Character vector of length one. Accepts either "hs" for Hursh and Silberberg (2008) or "koff" for Koffarnus, Franck, Stein, and Bickel (2015).}

\item{k}{A numeric vector of length one. Reflects the range of consumption in log10 units. If none provided, k will be calculated based on the max/min of the entire sample. If k = "fit", k will be a free parameter}

\item{remq0e}{If TRUE, removes consumption and price where price == 0. Default value is FALSE}

\item{replfree}{Optionally replaces price == 0 with specified value. Note, if fitting using equation == "hs", and 0 is first price, 0 gets replaced by replfree. Default value is .01}

\item{rem0}{If TRUE, removes all 0s in consumption data prior to analysis. Default value is FALSE.}

\item{nrepl}{Number of zeros to replace with replacement value (replnum). Can accept either a number or "all" if all zeros should be replaced. Default is to replace the first zero only.}

\item{replnum}{Value to replace zeros. Default is .01}

\item{plotcurves}{Boolean whether to create plot. If TRUE, a "plots/" directory is created one level above working directory. Default is FALSE.}

\item{method}{Character string of length 1. Accepts "Mean" to fit to mean data or "Pooled" to fit to pooled data}

\item{indpoints}{Boolean whether to plot individual points in gray. Default is TRUE.}

\item{vartext}{Character vector specifying indices to report on plots. Valid indices include "Q0d", "Alpha", "Q0e", "EV", "Pmaxe", "Omaxe", "Pmaxd", "Omaxd", "K", "Q0se", "Alphase", "R2", "AbsSS"}
}
\value{
Data frame
}
\description{
Fits curve to pooled data
}
\examples{
## Fit aggregated data (mean only) using Hursh & Silberberg, 2008 equation with a k fixed at 2
FitMeanCurves(apt[sample(apt$id, 5), ], "hs", k = 2, method = "Mean")
}
\author{
Brent Kaplan <bkaplan.ku@gmail.com>
}
