% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_rSq_ci.R
\name{lm_rSq_ci}
\alias{lm_rSq_ci}
\title{Obtaining an R squared confidence interval estimate for an lm regression}
\usage{
lm_rSq_ci(formula, data = NULL, conf.level = 0.95,
  ci.method = c("widest", "r.con", "olkinfinn"), env = parent.frame())
}
\arguments{
\item{formula}{The formula of the regression analysis, of the form \code{y ~
x1 + x2}, where y is the dependent variable and x1 and x2 are the
predictors.}

\item{data}{If the terms in the formula aren't vectors but variable names,
this should be the dataframe where those variables are stored.}

\item{conf.level}{The confidence of the confidence interval around the
regression coefficients.}

\item{ci.method}{Which method to use for the confidence
interval around R squared.}

\item{env}{The enviroment where to evaluate the formula.}

\item{\dots}{Any additional arguments are ignored.}
}
\value{
The confidence interval
}
\description{
The \code{lm_rSq_ci} function uses the base R \code{lm} function to conduct
a regression analysis and then computes the confidence interval for R squared.
}
\examples{

### Do a simple regression analysis
lm_rSq_ci(age ~ circumference, dat=Orange);

}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@a-bc.eu}{gjalt-jorn@a-bc.eu}
}
\keyword{utilities}
