% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.benchmark}
\alias{summary.benchmark}
\title{Summary method for the \code{benchmark} timings.}
\usage{
\method{summary}{benchmark}(object, relative = "median", ...)
}
\arguments{
\item{object}{An object of class \code{benchmark}.}

\item{relative}{Character. The name or index of the column whose values
will be used to compute relative timings.}

\item{\dots}{Not currently used.}
}
\value{
The method returns a \code{data.frame} with additional attributes,
which contains these columns:
\item{expr}{The deparsed expression as passed to
\code{benchmark} or the name of the argument if the expression was
passed as a named argument.}
\item{n.eval}{Number of successful measurements.}
\item{min}{Minimal timing measurement for this expression.}
\item{lw.qu}{First quartile of measurements for this expression.}
\item{mean}{Sample mean of measurements for this expression.}
\item{median}{Sample median of measurements for this expression.}
\item{up.qu}{Third quartile of measurements for this expression.}
\item{max}{Maximal timing measurement for this expression.}
\item{total}{Total (summed) measured time for this expression.}
\item{relative}{Relative difference across expressions compared to a minimal
value in the column, specified by the argument \code{relative}.}

Additional attributes:
\item{units}{Units for time intervals.}
}
\description{
This method computes aggregated statistics (quantiles, means and sums)
for each expression.
}
\examples{
timings <- benchmark(
    rchisq(100, 0), rchisq(100, 1), rchisq(100, 2),
    rchisq(100, 3), rchisq(100, 5), times = 1000L)
summary(timings)

}
\seealso{
\code{\link[=mean.benchmark]{mean.benchmark()}}
}
\author{
Artem Klevtsov \email{a.a.klevtsov@gmail.com}
}
