% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bender.R
\name{Bender}
\alias{Bender}
\title{Bender Client}
\description{
The Bender Class. Provides an interface to the Bender API. The goal with this client is to feed Bender with various trials.
Doing so, he will be more and more precise in the suggestions of hyperparameters set he makes.
}
\details{
\strong{/!\\ For fully detailed documentation on slots and methods, please visit} \url{https://bender-optimizer.readthedocs.io/en/latest/index.html}
}
\section{Slots}{

\code{mail} Mail of connected user.

\code{token} A unique JWT associated to your current session.

\code{experiment} The experiment object.

\code{algo} The algo object.
}

\section{Methods}{

\code{$new(mail, password)} Initialize a Bender object and establish connection to the API.

\code{$list_experiments()} Return a list of the connected user’s experiments.

\code{$set_experiment(name=NULL, id=NULL)} Setup current experiment for the connected user.

\code{$create_experiment(name, metrics, description=NULL, dataset=NULL, dataset_parameters=NULL)} Create new experiment and setup current experiment for the connected user. If experiment name already exists, the already existing one is set by default as current experiment.

\code{$delete_experiment(id)} Delete targeted experiment of the connected user.

\code{$list_algos()} Return a list of the connected user’s algos.

\code{$set_algo(id=NULL, name=NULL)} Setup current algo for the connected user.

\code{$set_algo(name, hyperparameters, description=NULL)} Create new algo and setup current algo for the connected user. If algo name already exists, the already existing one is set by default as current algo.

\code{$delete_algo(id)} Delete targeted algo of the connected user.

\code{$list_trials()} List all trials of the current algo.

\code{$create_trial(results, hyperparameters, weight=1, comment=NULL)} Create new trial for the current algo.

\code{$delete_trial(id)} Delete targeted trial from current algo.

\code{$suggest(metric=NULL, optimizer="parzen_estimator")} Ask bender a suggestion on a hyperparameters set to use

\code{$delete_trial(id)} Delete targeted trial from current algo.
}

\examples{
\dontrun{
my_optimization_problem <-function(data, hyperparameters) {
Do your magic here...
return(list(perform=0.3))
}

bender = Bender$new("my_bender_mail", "my_secret_password")

bender$set_algo(id="88155b59-aca1-4cb1-898c-25d942c02859")

suggested_hyperparameters <- bender$suggest(metric="accuracy")
results <- my_optimization_problem(my_data, suggested_hyperparameters)
bender$create_trial(list(accuracy=results.perform), suggested_hyperparameters)
}

}
