% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_accepted}
\alias{as_accepted}
\title{Convert Taxon Names to Comply with WoRMS/TWN}
\usage{
as_accepted(taxon, taxa = NULL)
}
\arguments{
\item{taxon}{\code{\link{character}} vector, containing taxon names}

\item{taxa}{an optional table usually created with \code{\link{read_taxa}}.}
}
\value{
character vector with WoRMS/TWN compliant species names
}
\description{
Taxon names are standardized according to the World Register of 
Marine Species (WoRMS) database. The conversion is case-insensitive.
For this conversion, the TWN-list (Taxa Water management the Netherlands) 
is used, extended with species of the Southern North Sea. 
See references below for download locations.
}
\references{
\url{http://www.marinespecies.org/}

\url{http://sofus.ecosys.nl/taxabase.htm}

\url{http://www.aquo.nl/faq/faq-twn/}
}
